subroutine steady(ulog,imx1)
use grids; use input_vars
implicit none
integer:: i,acnt,ulog,imx1
double precision :: b,rslo
!  By Rex L. Baum, 1 April 2004
!  Compute initial estimate of rikzero()=rizero/Kst (top layer), and test values.
!  rizero must be < Kst.  If cos(slo) *cos(slo)<rikzero, then an 
!  inverted water table results.
write(*,*) 'Testing and adjusting steady infiltration rates'
! calculate rikzero = rizero / kst
do i=1,imx1
    if(kst(zo(i))==0.) then ! prevent the error of division by zero
        rikzero(i)=1.
    else
        rikzero(i)=rizero(i)/kst(zo(i))
    end if
end do
  
!sumex=0 ! exfiltration
acnt=0
do i=1,imx1
    rslo=slo(i)
    b=cos(rslo)*cos(rslo)
    if(rikzero(i)>=b) then
        rikzero(i)=cos(rslo) 
        acnt=acnt+1
        write(ulog,*) 'Adjusted steady infiltration rate, cell ',i
        write(ulog,*) 'Corrected rizero/Kst = ',rikzero(i)
        write(ulog,*) 'Original rizero, kst',rizero(i),kst(zo(i))
        write(ulog,*) 'Set pore presssures to zero'
    end if
!    if (depth(i)==0 .and. rizero(i)<0) then
!        sumex=sumex-rizero(i)
!    end if
end do

write(*,*) 'Adjusted steady infiltration rate at ',acnt,' cells'
write(ulog,*) 'Adjusted steady infiltration rate at ',acnt,' cells'

return
end subroutine steady
